
/*
GetIdleAnimationCount();
GetIdleAnimation(S32 index);
GetIdleAnimationPropCount(S32 index);
GetIdleAnimationProp(S32 animation, S32 prop);
GetIdleAnimationMountPos(S32 animation, S32 prop);
*/

function AISMN_IdleTime::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %datablock = %object.getDatablock();
   %object.restoreOutfit = false;
   
   if (RandomNumber(1,100) > %data.getDataBlock().idleChance)
   {
      return;
   }
   
   %object.restoreOutfit = true;
   %animationCount = %datablock.getIdleAnimationCount();
   %animationIndex = RandomNumber(0, %animationCount);
   %animation = %datablock.getIdleAnimation(%animationIndex);
   %object.playThread(0, %animation);
   %object.animationIndex = %animationIndex;
   %object.animationTime = %datablock.getIdleAnimationTime(%animationIndex);
   
   %propCount = %datablock.GetIdleAnimationPropCount(%animationIndex);
   for (%index = 0; %index < %propCount; %index++)
   {
      %prop = %datablock.getIdleAnimationProp(%animationIndex, %index);
      %pos = %datablock.getIdleAnimationMountPos(%animationIndex, %index);

      %object.unmountImage(%pos);
      if (%pos != 0 || $HatEnabled == true)
      {
         %object.mountImage(%prop, %pos);
      }
   }
}

function AISMN_IdleTime::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "root");
   
   if (%object.restoreOutfit == true)
   {
      // unmount any objects that were added for the idle animation
      %datablock = %object.getDatablock();
      %propCount = %datablock.GetIdleAnimationPropCount(%animationIndex);
      for (%index = 0; %index < %propCount; %index++)
      {
         %pos = %datablock.getIdleAnimationMountPos(%animationIndex, %index);
         %object.unmountImage(%pos);
      }
      
      RestoreCharacterOutfit(%data, true);
   }
}

//EXIT 0: Done Idling.
function AISMN_IdleTime::Update(%this, %data)
{
   %object = GetThisObject(%data);
   
   //Are we done idling here?
   if (TimeInNode(%data) > %object.animationTime)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   ReturnValue(%data, -1);
}
